import warnings


class DefaultConfig(object):
    # train
    data_name = "cifar10"  # "cifar10"
    model_name = "ResNet"  # "ResNet18"
    train_mode = "std" # "JR", "stable  ", "adv", "LR"
    batch_size = 128
    delta = 0
    max_epoch = 80
    learning_rate = 0.1  # initial learning rate
    debug = False
    save_note = ""


    # regu
    lamda = 0.1
    JR_lamda = 0.1
    r = 300

    # device
    device_no = 0

    # experiment
    # attack
    aug_mode = "translate"  # "noise" "rotate"
    targeted = False

    attack_method = "pgd"
    bounding = "l2"
    # test
    evaluate_adv = False
    use_stand_adv_example = True

    # models
    latent_dim_cifar10 = 128
    latent_dim_mnist = 10
    # dataset
    train_buf_cifar = 50000
    test_buf_cifar = 10000
    train_buf_mnist = 60000
    test_buf_mnist = 10000

    # result folder
    path_ae_mnist = ""
    path_ae_cifar10 = ""
    path_ae_cifar100 = ""
    fig_sava_path = "result_figs/"


# 这里写在外面的原因猜测是防止这个方法被输出
def parse(self, kwargs):
    '''
    根据字典kwargs 更新 config参数
    '''
    for k, v in kwargs.items():
        if not hasattr(self, k):
            warnings.warn("Warning: opt has not attribut %s" % k)
        setattr(self, k, v)

    # print('user config:')
    # # 以字典的形式访问类的属性和方法
    # for k, v in self.__class__.__dict__.items():
    #     # 不输出保护属性
    #     if not k.startswith('__'):
    #         print(k, getattr(self, k))


DefaultConfig.parse = parse
opt = DefaultConfig()
